package com.xebialabs.deployit.engine.tasker.repository

import java.util

import com.xebialabs.deployit.engine.api.execution.{BlockState, TaskExecutionState, TaskPackageDependency, TaskWithBlock}
import com.xebialabs.deployit.engine.tasker.{Description, TaskId, TaskSpecification}
import org.joda.time.DateTime

import scala.beans.BeanProperty
import scala.util.Try

trait PendingTaskRepository {

  def tasks(loadFullSpec: Boolean): util.List[TaskWithBlock]

  def scheduledTasks(): util.List[TaskWithBlock]

  def queuedTasks(): util.List[PendingTask]

  def task(taskId: TaskId, loadFullSpec: Boolean = false): Option[PendingTask]

  def store(spec: TaskSpecification, workerAddress: Option[String] = None): TaskId

  def changeOwner(taskId: TaskId, newOwner: String): Unit

  def update(taskId: TaskId, spec: TaskSpecification): Unit

  def prepareToEnqueue(taskId: TaskId): Try[TaskWithBlock]

  def markAsSentToQueue(taskId: String): Unit

  def schedule(taskId: TaskId, date: DateTime): Unit

  def delete(taskId: TaskId): Unit
}

class PendingTask(@BeanProperty val id: TaskId,
                  @BeanProperty val description: Description,
                  @BeanProperty val owner: String,
                  @BeanProperty val metadata: util.Map[String, String],
                  @BeanProperty val scheduledDate: DateTime,
                  val spec: Option[TaskSpecification],
                  val workerAddress: Option[String],
                  @BeanProperty val queuedDate: DateTime,
                  val isSentToQueue: Boolean = false
                 ) extends TaskWithBlock {

  override def getBlock: BlockState = spec.map(_.getBlock).orNull

  override def getPackageDependencies: util.List[TaskPackageDependency] = spec.map(_.getPackageDependencies).orNull

  override def getState: TaskExecutionState =
    if (scheduledDate != null && !isSentToQueue) {
      TaskExecutionState.SCHEDULED
    } else if (isSentToQueue) {
      TaskExecutionState.QUEUED
    } else {
      TaskExecutionState.PENDING
    }

  override def getActiveBlocks: util.List[Description] = null

  override def getStartDate: DateTime = null

  override def getCompletionDate: DateTime = null

  override def getFailureCount: Int = 0

  override def getWorkerId: Integer = null
}
