package com.xebialabs.deployit.engine.tasker.distribution

import java.io.File

import akka.actor.{ActorRef, ActorRefFactory}
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory
import com.xebialabs.deployit.engine.tasker.log.{DefaultStepLogFactory, StepLogFactory}
import com.xebialabs.deployit.engine.tasker.{Task, TaskManagingActor, TaskSpecification}

class TaskActorCreatorImpl(repositoryFactory: RepositoryFactory, stepLogFactory: StepLogFactory, archiver: ActorRef) extends TaskActorCreator {

  override def create(taskSpecification: TaskSpecification, workerId: Integer, factory: ActorRefFactory): ActorRef = {
    val task = TaskCreator.taskFromSpec(taskSpecification, Some(repositoryFactory), stepLogFactory, workerId)
    create(task, factory)
  }

  override def create(task: Task, factory: ActorRefFactory): ActorRef = {
    factory.actorOf(TaskManagingActor.props(task, archiver, stepLogFactory), task.getId)
  }
}

object TaskCreator {

  def taskFromSpec(taskSpecification: TaskSpecification, repositoryFactory: Option[RepositoryFactory] = None,
                   stepLogFactory: StepLogFactory = new DefaultStepLogFactory, workerId: Integer = -1): Task = {
    new Task(
      taskSpecification.getId,
      taskSpecification,
      workerId,
      repositoryFactory.map(_.create(new File(taskSpecification.getWorkDir.getPath))).orNull,
      stepLogFactory
    )
  }
}
