package com.xebialabs.deployit.engine.tasker.log

import java.io.{PrintWriter, StringWriter}
import java.time.Instant

import com.xebialabs.deployit.engine.tasker.{BlockPath, TaskId, TaskStep}

trait StepLogFactory {
  def create(taskId: TaskId, stepPath: BlockPath, step: TaskStep): StepLog
}

trait ExternalStepLogFactory extends StepLogFactory {
  def append(taskId: TaskId, stepPath: BlockPath, timestamp: Instant, failureCount: Int, message: String): Unit
}

trait StepLog {

  private final val ERROR_PREFIX = "[ERROR]: "

  def logOutputRaw(output: String): Unit = doAppendLog(output)

  def logErrorRaw(error: String, t: Option[Throwable]): Unit = {
    doAppendLog(ERROR_PREFIX, error)
    t.foreach(logException)
  }

  private def logException(t: Throwable): Unit = {
    val stringWriter: StringWriter = new StringWriter
    t.printStackTrace(new PrintWriter(stringWriter))
    stringWriter.toString.split("\n").foreach(s => doAppendLog(ERROR_PREFIX, s, "\n"))
  }

  protected def doAppendLog(s: String*): Unit

  def markNextAttempt(): Unit

}
