package com.xebialabs.deployit.engine.tasker.satellite

import akka.actor.{ActorRef, ExtendedActorSystem}
import com.esotericsoftware.kryo.Kryo
import com.twitter.chill.{AllScalaRegistrar, EmptyScalaKryoInstantiator}
import com.xebialabs.deployit.core.MapStringStringView
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.utils.ClassLoaderUtils.classLoader
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer
import de.javakaffee.kryoserializers.jodatime.JodaDateTimeSerializer
import io.altoo.akka.serialization.kryo.serializer.akka.{ActorRefSerializer, ByteStringSerializer}
import io.altoo.akka.serialization.kryo.serializer.scala.{ScalaCollectionSerializer, ScalaImmutableMapSerializer, ScalaImmutableSetSerializer}
import org.joda.time.DateTime

import java.nio.file.Path
import scala.collection.mutable
import scala.jdk.CollectionConverters._

object KryoSerializer {

  def getMagicCombination(system: ExtendedActorSystem): Kryo = {

    val kryo = new EmptyScalaKryoInstantiator().newKryo()

    kryo.addDefaultSerializer(classOf[akka.util.ByteString], classOf[ByteStringSerializer])
    kryo.addDefaultSerializer(classOf[ActorRef], new ActorRefSerializer(system))

    kryo.register(scala.collection.immutable.Nil.getClass)

    // Serialization of Scala maps like Trees, etc
    kryo.addDefaultSerializer(classOf[scala.collection.Map[_, _]], classOf[ScalaImmutableMapSerializer])
    kryo.addDefaultSerializer(classOf[scala.collection.MapFactory[scala.collection.Map]], classOf[ScalaImmutableMapSerializer])

    // Serialization of Scala sets
    kryo.addDefaultSerializer(classOf[scala.collection.Set[_]], classOf[ScalaImmutableSetSerializer])

    // Serialization of all Traversable Scala collections like Lists, Vectors, etc
    kryo.addDefaultSerializer(classOf[scala.collection.Iterable[_]], classOf[ScalaCollectionSerializer])
    UnmodifiableCollectionsSerializer.registerSerializers(kryo)

    ImmutableListSerializer.registerSerializers(kryo)

    def useField[T](cls: Class[T]): Unit = {
      val fs = new com.esotericsoftware.kryo.serializers.FieldSerializer(kryo, cls)
      fs.setIgnoreSyntheticFields(false) // scala generates a lot of these attributes
      kryo.register(cls, fs)
    }

    // The wrappers are private classes:
    useField(Set(1, 2, 3).asJava.getClass)
    useField(mutable.Set(1, 2, 3).asJava.getClass)
    useField(Set(1, 2, 3).iterator.asJava.getClass)
    useField(mutable.Buffer(1, 2, 3).asJava.getClass)
    useField(mutable.Buffer(1, 2, 3).iterator.asJava.getClass)
    useField(classOf[MapStringStringView])

    new AllScalaRegistrar().apply(kryo)

    kryo.addDefaultSerializer(classOf[DateTime], new JodaDateTimeSerializer)
    kryo.addDefaultSerializer(classOf[Type], new XlTypeSerializer)
    kryo.addDefaultSerializer(classOf[Path], new PathSerializer)

    kryo.setClassLoader(classLoader)

    kryo
  }

}
