package com.xebialabs.deployit.engine.tasker.query


import com.xebialabs.deployit.engine.tasker.query.QueryExecutorHandler.{QueryPayload, QueryResponsePayload}

import java.io.{Serializable => JSerializable}
import java.util.concurrent.{ConcurrentHashMap, ConcurrentMap}

object QueryExecutorHandler {

  trait QueryPayload extends JSerializable {
    @transient
    def key(): String
  }

  type QueryResponsePayload = JSerializable

  private val executors: ConcurrentMap[String, QueryExecutor] = new ConcurrentHashMap()

  def register(queryExecutor: QueryExecutor, name: String): Unit =
    executors.put(name, queryExecutor)

  def execute(payload: QueryPayload): QueryResponsePayload =
    Option(executors.get(payload.getClass.getName))
      .map(_.query(payload))
      .getOrElse(throw new IllegalArgumentException(s"Cannot resolve QueryExecutor for ${payload.getClass.toString}"))
}

trait QueryExecutor {
  def query(payload: QueryPayload): QueryResponsePayload
}
