package com.xebialabs.deployit.engine.tasker.query

import akka.actor.{Actor, ActorRef, Props}
import com.xebialabs.deployit.engine.tasker.query.QueryActor.messages.{QueryRequest, QueryResponseFailure, QueryResponseSuccess}
import com.xebialabs.deployit.engine.tasker.query.QueryExecutorHandler.{QueryPayload, QueryResponsePayload}
import grizzled.slf4j.Logging

import scala.util.{Failure, Success, Try}

object QueryActor {

  val name = "query"

  def props(): Props = Props(new QueryActor())

  object messages {

    trait QueryResponse

    case class QueryRequest(query: QueryPayload, notificationActor: ActorRef)

    case class QueryResponseSuccess[R <: QueryResponsePayload](response: R) extends QueryResponse

    case class QueryResponseFailure(message: String, ex: Throwable = null) extends QueryResponse
  }
}

class QueryActor extends Actor with Logging {

  def receive: Actor.Receive = {
    case QueryRequest(query, notificationActor) =>
      debug(s"Received [QueryRequest] message with query [$query].")
      Try(QueryExecutorHandler.execute(query)) match {
        case Success(response) if response != null =>
          notificationActor ! QueryResponseSuccess(response)
        case Success(_) =>
          notificationActor ! QueryResponseFailure("Result cannot be null")
          error(s"Failed to execute [QueryRequest] with query [$query] result cannot be null")
        case Failure(ex) =>
          notificationActor ! QueryResponseFailure(ex.getMessage, ex)
          error(s"Failed to execute [QueryRequest] with query [$query]", ex)
      }
    case m@_ => error(s"I don't understand message [$m]")
  }
}
