package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.security.MessageDigest

import com.xebialabs.deployit.util.JavaCryptoUtils

import scala.collection.mutable

trait ParentItem extends ConfigurationTreeItem {

  object HashAlphabetOrdering extends Ordering[ConfigurationTreeItem] {

    def compare(first: ConfigurationTreeItem, second: ConfigurationTreeItem): Int = first.calculateConfigHash.compareTo(second.calculateConfigHash)

  }

  var children: mutable.TreeSet[ConfigurationTreeItem] = new mutable.TreeSet[ConfigurationTreeItem]()(HashAlphabetOrdering)

  override def calculateConfigHash: String = {
    if (configHash == null) {
      val hash: MessageDigest = checksumAlgorithmProvider.getMessageDigest
      children.foreach(item => hash.update(item.calculateConfigHash.getBytes("UTF-8")))
      configHash = JavaCryptoUtils.digest(hash)
    }
    configHash
  }

  def addChild(configurationTreeItem: ConfigurationTreeItem): Unit = {
    invalidateConfigHash()
    children += configurationTreeItem
  }

}
