package com.xebialabs.deployit.tasksystem

import com.typesafe.config.Config
import org.apache.pekko.actor.BootstrapSetup
import org.apache.pekko.actor.setup.{ActorSystemSetup, Setup}

import scala.reflect.runtime.universe

trait PekkoSetupProvider {

  def apply(systemConfig: Config): Setup

}

object PekkoSetupProvider {

  val serializationPekkoSetupProviderProp = "deploy.task.serialization.pekko-setup-provider"

  def apply(systemConfig: Config): ActorSystemSetup = {
    val actorConfig = if (systemConfig.hasPath("deploy.task.system"))
      systemConfig.getConfig("deploy.task.system").withFallback(systemConfig)
    else
      systemConfig

    val setup = ActorSystemSetup(BootstrapSetup(None, Some(ConfigLoading.loadConfig(actorConfig)), None))

    if (systemConfig.hasPath(serializationPekkoSetupProviderProp)) {
      val serializationPekkoSetupProvider: PekkoSetupProvider = companion[PekkoSetupProvider](
        systemConfig.getString(serializationPekkoSetupProviderProp)
      )
      setup.and(serializationPekkoSetupProvider(systemConfig))
    } else {
      setup
    }
  }

  private def companion[T](name: String)(implicit man: Manifest[T]): T = {
    val runtimeMirror = universe.runtimeMirror(getClass.getClassLoader)
    val module = runtimeMirror.staticModule(name)
    val obj = runtimeMirror.reflectModule(module)
    obj.instance.asInstanceOf[T]
  }
}
