package com.xebialabs.deployit.tasksystem

import akka.actor.ActorSystem
import com.typesafe.config.ConfigFactory._
import com.typesafe.config.{Config, ConfigFactory}
import com.xebialabs.xlplatform.config.{ConfigLoader, ConfigurationHolder}

object TaskActorSystem {

  lazy val actorSystem: ActorSystem = newActorSystem(overrideConfig.withFallback(ConfigLoader.loadWithDynamic(ConfigurationHolder.get())))

  var overrideConfig: Config = ConfigFactory.empty()

  def setOverrideConfig(newConfig: Config): Unit = {
    overrideConfig = newConfig
  }

  def newActorSystem(systemConfig: Config, systemName: Option[String] = None): ActorSystem = {
    val actorConfig = if (systemConfig.hasPath("deploy.task.system"))
      systemConfig.getConfig("deploy.task.system").withFallback(systemConfig)
    else
      systemConfig
    ActorSystem.create(systemName.getOrElse("task-sys"), ConfigLoading.loadConfig(actorConfig))
  }
}
