package com.xebialabs.xlplatform.test.tasksystem

import com.xebialabs.deployit.engine.api.execution.TaskWithBlock
import com.xebialabs.deployit.engine.tasker.repository.{PendingTask, PendingTaskRepository}
import com.xebialabs.deployit.engine.tasker.{TaskId, TaskSpecification}
import grizzled.slf4j.Logging
import org.joda.time.DateTime

import java.util
import scala.collection.mutable
import scala.jdk.CollectionConverters._
import scala.util.Try

class InMemoryPendingTaskRepository extends PendingTaskRepository with Logging {

  private val _tasks = mutable.Map[TaskId, (TaskSpecification, Option[DateTime], Option[DateTime])]()

  override def delete(taskId: TaskId): Unit = _tasks.remove(taskId)

  override def tasks(loadFullSpec: Boolean): util.List[TaskWithBlock] = {
    _tasks.map { case (id, (spec, scheduledDate, queuedDate)) => pendingTask(id)(spec, scheduledDate, queuedDate).asInstanceOf[TaskWithBlock] }.toList.asJava
  }

  override def task(taskId: TaskId, loadFullSpec: Boolean = false): Option[PendingTask] = {
    val task: Option[PendingTask] = _tasks.get(taskId).map { case (spec, scheduledDate, queuedDate) => pendingTask(taskId)(spec, scheduledDate, queuedDate) }
    task
  }

  override def store(spec: TaskSpecification, workerAddress: Option[String]): TaskId = {
    val taskId = spec.getId
    _tasks.put(taskId, (spec, None, None))
    taskId
  }

  override def changeOwner(taskId: TaskId, newOwner: String): Unit = ???

  override def update(taskId: TaskId, spec: TaskSpecification): Unit = {
    task(taskId, loadFullSpec = true).foreach { t => _tasks.put(taskId, (t.spec.get, Some(t.scheduledDate), Some(t.queuedDate))) }
  }

  override def markAsSentToQueue(taskId: String): Unit = {
    logger.warn(s"markAsSentToQueue for taskId $taskId : This method is not implemented!")
  }

  override def schedule(taskId: TaskId, date: DateTime): Unit = {
    task(taskId, loadFullSpec = true).foreach { t => _tasks.put(taskId, (t.spec.get, Some(date), None)) }
  }

  private def pendingTask(id: TaskId)(spec: TaskSpecification, scheduledDate: Option[DateTime], queuedDate: Option[DateTime]): PendingTask = {
    new PendingTask(id, spec.getDescription, spec.getOwner.getName, spec.getMetadata, null, Some(spec), None, null)
  }

  override def scheduledTasks(): util.List[TaskWithBlock] = _tasks.foldLeft[List[TaskWithBlock]](List.empty) {
    case (acc, (taskId, (spec, date: Some[DateTime], queuedDate: Option[DateTime]))) => pendingTask(taskId)(spec, date, queuedDate) :: acc
    case (acc, _) => acc
  }.asJava

  override def queuedTasks(): util.List[PendingTask] = _tasks.foldLeft[List[PendingTask]](List.empty) {
    case (acc, (taskId, (spec, date: Option[DateTime], queuedDate: Some[DateTime]))) => pendingTask(taskId)(spec, date, queuedDate) :: acc
    case (acc, _) => acc
  }.asJava

  override def prepareToEnqueue(taskId: TaskId): Try[TaskWithBlock] = Try(task(taskId).get)
}
