
package ai.digital.deploy.task.serdes

import com.xebialabs.deployit.repository.WorkDir
import com.xebialabs.deployit.tasksystem.TaskActorSystem
import org.apache.pekko.actor.{ActorSystem, ExtendedActorSystem}
import org.apache.pekko.serialization.{SerializationExtension, Serializer => PekkoSerializer}

import java.io.File
import java.util.concurrent.ConcurrentHashMap

object TaskPekkoSerializer {

  case class Conf(baseWorkDir: File)

  private val serializerMap: ConcurrentHashMap[String, TaskPekkoSerializer] = new ConcurrentHashMap()

  def taskPekkoSerializer(actorSystem: ActorSystem, clazz: Class[_]): TaskPekkoSerializer =
    SerializationExtension(actorSystem.asInstanceOf[ExtendedActorSystem])
      .serializerFor(clazz).asInstanceOf[TaskPekkoSerializer]

  def currentTaskPekkoSerializer(actorSystem: ActorSystem = TaskActorSystem.actorSystem): TaskPekkoSerializer =
    taskPekkoSerializer(actorSystem, classOf[java.io.Serializable])

  def getTaskPekkoSerializerByClass(clazz: Class[_], actorSystem: ActorSystem = TaskActorSystem.actorSystem): TaskPekkoSerializer =
      taskPekkoSerializer(actorSystem, clazz)

  def getTaskPekkoSerializerByName(serializerName: String, actorSystem: ActorSystem = TaskActorSystem.actorSystem): TaskPekkoSerializer =
    serializerMap.computeIfAbsent(serializerName, name => {
      val fqn = actorSystem.settings.config.getConfig("pekko.actor.serializers").getString(name)
      val serializer = SerializationExtension(actorSystem.asInstanceOf[ExtendedActorSystem]).serializerByIdentity.values
        .find(_.getClass.getName == fqn)
        .get
        .asInstanceOf[TaskPekkoSerializer]
      serializer
    })

  def initExternalWorker(conf: Conf, actorSystem: ActorSystem = TaskActorSystem.actorSystem, createWorkDir: Boolean = true): Unit =
    taskPekkoSerializer(actorSystem, classOf[WorkDir]).initExternalWorker(conf, createWorkDir)
}

trait TaskPekkoSerializer extends PekkoSerializer {
  def initExternalWorker(conf: TaskPekkoSerializer.Conf, createWorkDir: Boolean = true): Unit
}
