
package ai.digital.deploy.task.serdes

import akka.actor.{ActorSystem, ExtendedActorSystem}
import akka.serialization.{SerializationExtension, Serializer => AkkaSerializer}
import com.xebialabs.deployit.repository.WorkDir
import com.xebialabs.deployit.tasksystem.TaskActorSystem

import java.io.File
import java.util.concurrent.ConcurrentHashMap

object TaskAkkaSerializer {

  case class Conf(baseWorkDir: File)

  private val serializerMap: ConcurrentHashMap[String, TaskAkkaSerializer] = new ConcurrentHashMap()

  def taskAkkaSerializer(actorSystem: ActorSystem, clazz: Class[_]): TaskAkkaSerializer =
    SerializationExtension(actorSystem.asInstanceOf[ExtendedActorSystem])
      .serializerFor(clazz).asInstanceOf[TaskAkkaSerializer]

  def currentTaskAkkaSerializer(actorSystem: ActorSystem = TaskActorSystem.actorSystem): TaskAkkaSerializer =
    taskAkkaSerializer(actorSystem, classOf[java.io.Serializable])

  def getTaskAkkaSerializerByClass(clazz: Class[_], actorSystem: ActorSystem = TaskActorSystem.actorSystem): TaskAkkaSerializer =
      taskAkkaSerializer(actorSystem, clazz)

  def getTaskAkkaSerializerByName(serializerName: String, actorSystem: ActorSystem = TaskActorSystem.actorSystem): TaskAkkaSerializer =
    serializerMap.computeIfAbsent(serializerName, name => {
      val fqn = actorSystem.settings.config.getConfig("akka.actor.serializers").getString(name)
      val serializer = SerializationExtension(actorSystem.asInstanceOf[ExtendedActorSystem]).serializerByIdentity.values
        .find(_.getClass.getName == fqn)
        .get
        .asInstanceOf[TaskAkkaSerializer]
      serializer
    })

  def initExternalWorker(conf: Conf, actorSystem: ActorSystem = TaskActorSystem.actorSystem, createWorkDir: Boolean = true): Unit =
    taskAkkaSerializer(actorSystem, classOf[WorkDir]).initExternalWorker(conf, createWorkDir)
}

trait TaskAkkaSerializer extends AkkaSerializer {
  def initExternalWorker(conf: TaskAkkaSerializer.Conf, createWorkDir: Boolean = true): Unit
}
