package akka.serialization.jackson

import ai.digital.deploy.task.serdes.DeployStringQuotingChecker
import akka.actor.ExtendedActorSystem
import com.fasterxml.jackson.dataformat.yaml.{YAMLFactory, YAMLGenerator}

final class JacksonYamlSerializer(system: ExtendedActorSystem, bindingName: String)
  extends JacksonSerializer(
    system,
    bindingName: String,
    JacksonObjectMapperProvider(system).getOrCreate(
      bindingName,
      Some(
        new YAMLFactory()
          .disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID)
          .disable(YAMLGenerator.Feature.USE_NATIVE_OBJECT_ID)
          .disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)
          .enable(YAMLGenerator.Feature.MINIMIZE_QUOTES)
          .rebuild()
          .stringQuotingChecker(DeployStringQuotingChecker)
          .build()
      )
    )
      .deactivateDefaultTyping()
  )

