
package ai.digital.deploy.task.serdes

import akka.actor.{ActorSystem, ExtendedActorSystem}
import akka.serialization.{SerializationExtension, Serializer => AkkaSerializer}
import com.xebialabs.deployit.repository.WorkDir
import com.xebialabs.deployit.tasksystem.TaskActorSystem
import java.io.File

object TaskAkkaSerializer {

  case class Conf(baseWorkDir: File)

  def taskAkkaSerializer(actorSystem: ActorSystem, clazz: Class[_]): TaskAkkaSerializer = {
    SerializationExtension(actorSystem.asInstanceOf[ExtendedActorSystem])
      .serializerFor(clazz).asInstanceOf[TaskAkkaSerializer]
  }

  def currentTaskAkkaSerializer(actorSystem: ActorSystem = TaskActorSystem.actorSystem): TaskAkkaSerializer = taskAkkaSerializer(actorSystem, classOf[java.io.Serializable])

  def getTaskAkkaSerializer(clazz: Class[_], actorSystem: ActorSystem = TaskActorSystem.actorSystem): TaskAkkaSerializer = {
      taskAkkaSerializer(actorSystem, clazz)
  }

  def initExternalWorker(conf: Conf, actorSystem: ActorSystem = TaskActorSystem.actorSystem): Unit = {
    taskAkkaSerializer(actorSystem, classOf[WorkDir]).initExternalWorker(conf)
  }
}

trait TaskAkkaSerializer extends AkkaSerializer {
  def initExternalWorker(conf: TaskAkkaSerializer.Conf): Unit
}
