package ai.digital.deploy.task.serdes.deploy

import ai.digital.deploy.task.serdes.DeployJacksonObjectMapperFactory.loadClass
import com.fasterxml.jackson.databind.Module.SetupContext
import com.fasterxml.jackson.databind.module.SimpleModule

class DeployModule extends SimpleModule {

  val mixins = Map(
    "com.xebialabs.deployit.service.deployment.ReferentialIntegrityTrigger" -> classOf[MixinForReferentialIntegrityTrigger]
  )

  override def setupModule(context: SetupContext) {
    mixins
      .foreach {
        case (clazz, mixin) => loadClass(clazz).foreach(context.setMixInAnnotations(_, mixin))
      }
  }
}
