package ai.digital.deploy.task

import com.fasterxml.jackson.annotation._
import com.fasterxml.jackson.databind.JsonNode
import com.fasterxml.jackson.databind.node.MissingNode

package object serdes {

  def readJsonNode(jsonNode: JsonNode, field: String): JsonNode = if (jsonNode.has(field))
    jsonNode.get(field)
  else
    MissingNode.getInstance

  @JsonIgnoreType
  abstract class MixinForIgnoreType {}

  @JsonTypeInfo(
    use = JsonTypeInfo.Id.MINIMAL_CLASS,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__dt"
  )
  abstract class MixinWithJsonTypeInfo {}

}
