package ai.digital.deploy.task.serdes

import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker

object DeployStringQuotingChecker extends StringQuotingChecker {

  override def needToQuoteName(name: String): Boolean = isReservedKeyword(name) || looksLikeYAMLNumber(name) || name.contains('/')

  override def needToQuoteValue(value: String): Boolean = isReservedKeyword(value) || valueHasQuotableChar(value)
}
