package ai.digital.deploy.task.serdes

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.deser.{DeserializationProblemHandler, ValueInstantiator}
import grizzled.slf4j.Logging

object DeployDeserializationProblemHandler extends DeserializationProblemHandler with Logging {

  override def handleMissingInstantiator(ctxt: DeserializationContext, instClass: Class[_], valueInsta: ValueInstantiator, p: JsonParser, msg: String): Any =
    if (msg.startsWith("cannot deserialize from Object value")) {

      logger.debug(s"Handling missing instantiator for $instClass with silent object creator")

      val value = SilentObjectCreator.create(instClass)
      val deserializer = ctxt.findRootValueDeserializer(ctxt.constructType(instClass))
      deserializer.deserialize(p, ctxt, value)
    } else {
      super.handleMissingInstantiator(ctxt, instClass, valueInsta, p, msg)
    }

}
