package ai.digital.deploy.task.serdes.tasker

import ai.digital.deploy.task.serdes.{MixinForIgnoreType, MixinWithJsonTypeInfo}
import com.fasterxml.jackson.databind.{BeanDescription, DeserializationConfig}
import com.fasterxml.jackson.databind.Module.SetupContext
import com.fasterxml.jackson.databind.deser.ValueInstantiator
import com.fasterxml.jackson.databind.module.SimpleModule
import com.xebialabs.deployit.booter.remote.BooterConfig
import com.xebialabs.deployit.engine.api.execution.{BlockState, StepState}
import com.xebialabs.deployit.engine.spi.execution.{ExecutionStateListener, NonRemotableExecutionStateListener}
import com.xebialabs.deployit.engine.tasker.{TaskSpecification, TaskStep}
import com.xebialabs.deployit.io.{DerivedArtifactFile, SupplierWorkDir}
import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, DeltaSpecification, DeltaSpecificationWithDependencies}
import com.xebialabs.deployit.plugin.api.flow.{StagedFile, Step}
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.WorkDir
import com.xebialabs.deployit.task.WorkdirCleanerTrigger

class TaskerModule extends SimpleModule {

  override def setupModule(context: SetupContext) {
    context.setMixInAnnotations(classOf[NonRemotableExecutionStateListener], classOf[MixinForIgnoreType])

    context.setMixInAnnotations(classOf[ConfigurationItem], classOf[MixinForConfigurationItem])

    context.setMixInAnnotations(classOf[Step], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[StagedFile], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[DeltaSpecificationWithDependencies], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[DeltaSpecification], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[Delta], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[BlockState], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[StepState], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[ExecutionStateListener], classOf[MixinWithJsonTypeInfo])

    context.setMixInAnnotations(classOf[SupplierWorkDir], classOf[MixinForSupplierWorkDir])
    context.setMixInAnnotations(classOf[DescriptorRegistryId], classOf[MixinForDescriptorRegistryId])
    context.setMixInAnnotations(classOf[WorkDir], classOf[MixinForWorkDir])
    context.setMixInAnnotations(classOf[TaskSpecification], classOf[MixinForTaskSpecification])
    context.setMixInAnnotations(classOf[TaskStep], classOf[MixinForTaskStep])
    context.setMixInAnnotations(classOf[BooterConfig], classOf[MixinForBooterConfig])
    context.setMixInAnnotations(classOf[WorkdirCleanerTrigger], classOf[MixinForWorkdirCleanerTrigger])
    context.setMixInAnnotations(classOf[DerivedArtifactFile], classOf[MixinForDerivedArtifactFile])
  }
}
