package ai.digital.deploy.task.serdes

import com.fasterxml.jackson.annotation.{JsonCreator, JsonProperty}
import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, DeltaSpecification, Operation}
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.udm.{Container, Deployable, Deployed, DeployedApplication}

import java.util

package object planner {

  @JsonCreator
  abstract class MixinForMultiDeltaSpecification(@JsonProperty("deltaSpecifications") allDeltaSpecifications: util.List[util.List[DeltaSpecification]],
                                                 @JsonProperty("mainApplication") mainApplication: DeployedApplication) {}

  @JsonCreator
  abstract class MixinForDefaultDeltaSpecification(@JsonProperty("operation") operation: Operation,
                                                   @JsonProperty("previousDeployedApplication") previousDeployedApplication: DeployedApplication,
                                                   @JsonProperty("deployedApplication") deployedApplication: DeployedApplication,
                                                   @JsonProperty("deltas") deltas: util.List[Delta],
                                                   @JsonProperty("rollback") rollback: Boolean) {}

  @JsonCreator
  abstract class MixinForDefaultDelta(@JsonProperty("operation") operation: Operation,
                                      @JsonProperty("previous") previous: Deployed[_ <: Deployable, _ <: Container],
                                      @JsonProperty("deployed") deployed: Deployed[_ <: Deployable, _ <: Container],
                                      @JsonProperty("intermediateCheckpointNames") intermediateCheckpointNames: util.List[String]) {}

  @JsonCreator
  abstract class MixinForCheckpoint(@JsonProperty("delta") delta: Delta, @JsonProperty("step") step: Step) {}

}
