package ai.digital.deploy.task.serdes.overthere

import ai.digital.deploy.task.serdes.{MixinForIgnoreType, MixinWithJsonTypeInfo}
import com.fasterxml.jackson.databind.Module.SetupContext
import com.fasterxml.jackson.databind.module.SimpleModule
import com.xebialabs.overthere.{OverthereConnection, OverthereFile}
import com.xebialabs.overthere.local.LocalConnection
import com.xebialabs.overthere.spi.AddressPortMapper

class OverthereModule extends SimpleModule {

  override def setupModule(context: SetupContext) {
    context.setMixInAnnotations(classOf[AddressPortMapper], classOf[MixinForIgnoreType])

    context.setMixInAnnotations(classOf[OverthereFile], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[OverthereConnection], classOf[MixinWithJsonTypeInfo])

    context.setMixInAnnotations(classOf[LocalConnection], classOf[MixinWithLocalConnection])
  }
}
