package ai.digital.deploy.task.serdes.yaml.tasker

import ai.digital.deploy.task.serdes.yaml.MixinWithJsonTypeInfo
import com.fasterxml.jackson.databind.Module.SetupContext
import com.fasterxml.jackson.databind.module.{SimpleDeserializers, SimpleKeyDeserializers, SimpleModule, SimpleSerializers}
import com.xebialabs.deployit.booter.remote.BooterConfig
import com.xebialabs.deployit.engine.api.execution.{BlockState, StepState}
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener
import com.xebialabs.deployit.engine.tasker.{BlockPath, TaskSpecification, TaskStep}
import com.xebialabs.deployit.io.{DerivedArtifactFile, SupplierWorkDir}
import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, DeltaSpecification, DeltaSpecificationWithDependencies}
import com.xebialabs.deployit.plugin.api.flow.{StagedFile, Step}
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.WorkDir
import com.xebialabs.deployit.task.WorkdirCleanerTrigger

class TaskerModule extends SimpleModule {

  override def setupModule(context: SetupContext) {

    context.setMixInAnnotations(classOf[ConfigurationItem], classOf[MixinForConfigurationItem])

    context.setMixInAnnotations(classOf[Step], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[StagedFile], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[DeltaSpecificationWithDependencies], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[DeltaSpecification], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[Delta], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[BlockState], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[StepState], classOf[MixinWithJsonTypeInfo])
    context.setMixInAnnotations(classOf[ExecutionStateListener], classOf[MixinWithJsonTypeInfo])

    context.setMixInAnnotations(classOf[SupplierWorkDir], classOf[MixinForSupplierWorkDir])
    context.setMixInAnnotations(classOf[DescriptorRegistryId], classOf[MixinForDescriptorRegistryId])
    context.setMixInAnnotations(classOf[WorkDir], classOf[MixinForWorkDir])
    context.setMixInAnnotations(classOf[TaskSpecification], classOf[MixinForTaskSpecification])
    context.setMixInAnnotations(classOf[TaskStep], classOf[MixinForTaskStep])
    context.setMixInAnnotations(classOf[BooterConfig], classOf[MixinForBooterConfig])
    context.setMixInAnnotations(classOf[WorkdirCleanerTrigger], classOf[MixinForWorkdirCleanerTrigger])
    context.setMixInAnnotations(classOf[DerivedArtifactFile], classOf[MixinForDerivedArtifactFile])

    val serializers = new SimpleSerializers()
    serializers.addSerializer(classOf[BlockPath], new BlockPathSerializer)
    context.addSerializers(serializers)

    val deserializers = new SimpleDeserializers()
    deserializers.addDeserializer(classOf[BlockPath], new BlockPathDeserializer)
    context.addDeserializers(deserializers)

    context.addKeySerializers(serializers)
    context.addKeyDeserializers(new SimpleKeyDeserializers()
      .addDeserializer(classOf[BlockPath], new BlockPathKeyDeserializer)
    )
  }
}
