package ai.digital.deploy.task.serdes.kryo

import com.esotericsoftware.kryo.kryo5.SerializerFactory
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer
import com.twitter.chill.{KSerializer, KryoBase}

class TwitterChillKryoBase extends KryoBase {

  override def newDefaultSerializer(klass: Class[_]): KSerializer[_] =
    if (isSingleton(klass)) {
      objSer
    } else {
      val defaultSerializer = new SerializerFactory.FieldSerializerFactory
      defaultSerializer.newSerializer(this, klass) match {
        case fs: FieldSerializer[_] =>
          //Scala has a lot of synthetic fields that must be serialized:
          //We also enable it by default in java since not wanting these fields
          //serialized looks like the exception rather than the rule.

          fs.getFieldSerializerConfig.setIgnoreSyntheticFields(false)
          fs.updateFields()

          /**
           * This breaks scalding, but something like this should be used when
           * working with the repl.
           *
           * if(isFn(klass))
           * new CleaningSerializer(fs.asInstanceOf[FieldSerializer[AnyRef] ])
           * else
           */
          fs
        case x: KSerializer[_] => x
      }
    }
}
