package ai.digital.deploy.task.serdes.kryo

import com.esotericsoftware.kryo.kryo5.Kryo
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer.CachedField
import com.xebialabs.deployit.engine.tasker.TaskStep
import org.apache.pekko.actor.ExtendedActorSystem

import scala.util.Try

class TaskStepSerializer(kryo: Kryo) extends FieldSerializer[TaskStepSerializer](kryo, classOf[TaskStep]) {
  override def initializeCachedFields(): Unit = {
    getFields.find(_.getField.getName == "implementation").foreach(removeField)
  }

  override def removeField(fieldName: String): Unit = Try(super.removeField(fieldName))

  override def removeField(removeField: CachedField): Unit = Try(super.removeField(removeField))
}

object TaskStepSerializer {
  private[kryo] def kryo(system: ExtendedActorSystem) = {
    val kryo = KryoSerializer.getMagicCombination(system)
    kryo.register(classOf[TaskStep], new TaskStepSerializer(kryo))
    kryo
  }

}
