package ai.digital.deploy.task.serdes.kryo

import com.esotericsoftware.kryo.kryo5.Kryo
import com.esotericsoftware.kryo.kryo5.io.Input
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer
import com.xebialabs.deployit.repository.WorkDir

import java.io.File

class WorkDirSerializer(kryo: Kryo, baseWorkDir: File, create: Boolean = false) extends FieldSerializer[WorkDir](kryo, classOf[WorkDir]) {

  override def read(kryo: Kryo, input: Input, `type`: Class[_ <: WorkDir]): WorkDir = {
    val workDir = super.read(kryo, input, `type`)
    workDir.rebase(baseWorkDir, create)
  }
}
