package ai.digital.deploy.task.serdes.kryo

import ai.digital.deploy.task.serdes.kryo.javakaffee.jodatime.JodaDateTimeSerializer
import com.esotericsoftware.kryo.kryo5.Kryo
import org.joda.time.DateTime

// magro / javakaffe / kryo-serializers:
object JavaKaffeeSerializers extends Registrar {
  override def apply(implicit kryo: Kryo): Unit = {
    UnmodifiableCollectionsSerializer.registerSerializers(kryo)
    ImmutableListSerializer.registerSerializers(kryo)

    kryo.addDefaultSerializer(classOf[DateTime], new JodaDateTimeSerializer)
  }
}
