package ai.digital.deploy.task.serdes.kryo

import com.esotericsoftware.kryo.Kryo
import de.javakaffee.kryoserializers.jodatime.JodaDateTimeSerializer
import org.joda.time.DateTime

// magro / javakaffe / kryo-serializers:
object JavaKaffeeSerializers extends Registrar {
  override def apply(implicit kryo: Kryo): Unit = {
    UnmodifiableCollectionsSerializer.registerSerializers(kryo)
    ImmutableListSerializer.registerSerializers(kryo)

    kryo.addDefaultSerializer(classOf[DateTime], new JodaDateTimeSerializer)
  }
}
