package ai.digital.deploy.task.serdes.kryo

import akka.actor.{ActorRef, ExtendedActorSystem}
import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.serializers.DefaultSerializers.{AtomicBooleanSerializer, AtomicIntegerSerializer, AtomicLongSerializer, AtomicReferenceSerializer}
import com.esotericsoftware.kryo.serializers.FieldSerializer
import com.xebialabs.deployit.core.MapStringStringView
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.utils.ClassLoaderUtils.classLoader
import io.altoo.akka.serialization.kryo.serializer.akka.{ActorRefSerializer, ByteStringSerializer}
import io.altoo.akka.serialization.kryo.serializer.scala.{ScalaCollectionSerializer, ScalaImmutableMapSerializer, ScalaImmutableSetSerializer}

import java.nio.file.Path
import java.util.concurrent.atomic.{AtomicBoolean, AtomicInteger, AtomicLong, AtomicReference}

object KryoSerializer {

  def getMagicCombination(system: ExtendedActorSystem): Kryo = {

    val kryo: TwitterChillKryoBase = new ai.digital.deploy.task.serdes.kryo.EmptyScalaKryoInstantiator().newKryo()
    akkaSerializers(kryo, system)
    scalaSerializers(kryo)
    javaUtilConcurrentAtomicSerializers(kryo)
    JavaKaffeeSerializers(kryo)
    TwitterChillSerializers(kryo)
    deploySerializers(kryo)
    kryo
  }

  private def scalaSerializers(kryo: Kryo): Unit = {
    kryo.register(scala.collection.immutable.Nil.getClass)

    // Serialization of Scala maps like Trees, etc
    kryo.addDefaultSerializer(classOf[scala.collection.Map[_, _]], classOf[ScalaImmutableMapSerializer])
    kryo.addDefaultSerializer(classOf[scala.collection.MapFactory[scala.collection.Map]], classOf[ScalaImmutableMapSerializer])

    // Serialization of Scala sets
    kryo.addDefaultSerializer(classOf[scala.collection.Set[_]], classOf[ScalaImmutableSetSerializer])

    // Serialization of all Traversable Scala collections like Lists, Vectors, etc
    kryo.addDefaultSerializer(classOf[scala.collection.Iterable[_]], classOf[ScalaCollectionSerializer])
  }

  private def deploySerializers(kryo: Kryo): Unit = {
    kryo.addDefaultSerializer(classOf[Type], new XlTypeSerializer)
    kryo.addDefaultSerializer(classOf[Path], new PathSerializer)
    kryo.addDefaultSerializer(classOf[MapStringStringView], classOf[FieldSerializer[_]])

    kryo.setClassLoader(classLoader)
  }

  private def akkaSerializers(kryo: Kryo, system: ExtendedActorSystem): Unit = {
    kryo.addDefaultSerializer(classOf[akka.util.ByteString], classOf[ByteStringSerializer])
    kryo.addDefaultSerializer(classOf[ActorRef], new ActorRefSerializer(system))
  }

  private def javaUtilConcurrentAtomicSerializers(kryo: Kryo): Unit = {
    kryo.register(classOf[AtomicBoolean], new AtomicBooleanSerializer)
    kryo.register(classOf[AtomicInteger], new AtomicIntegerSerializer)
    kryo.register(classOf[AtomicLong], new AtomicLongSerializer)
    kryo.register(classOf[AtomicReference[_]], new AtomicReferenceSerializer)
  }
}


