package ai.digital.deploy.task.serdes.kryo

import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.{Kryo, Serializer}

import java.nio.file.{Path, Paths => NIOPaths}
import java.util
import scala.jdk.CollectionConverters._

class PathSerializer extends Serializer[Path] {
  override def write(kryo: Kryo, output: Output, path: Path): Unit = {
    val pathElements = (Option(path.getRoot).toList ::: path.iterator().asScala.toList).map(_.toString)
    kryo.writeObject(output, new util.ArrayList[String](pathElements.asJava))
  }

  override def read(kryo: Kryo, input: Input, `type`: Class[Path]): Path = {
    val (root :: tail) = kryo.readObject(input, classOf[util.ArrayList[String]]).asScala.toList
    NIOPaths.get(root, tail: _*)
  }
}
