package ai.digital.deploy.task.serdes.kryo

import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.io.Input
import com.esotericsoftware.kryo.serializers.FieldSerializer
import com.xebialabs.deployit.repository.WorkDir

import java.io.File

class WorkDirSerializer(kryo: Kryo, baseWorkDir: File, create: Boolean = false) extends FieldSerializer[WorkDir](kryo, classOf[WorkDir]) {

  override def read(kryo: Kryo, input: Input, `type`: Class[WorkDir]): WorkDir = {
    val workDir = super.read(kryo, input, `type`)
    workDir.rebase(baseWorkDir, create)
  }
}
