package com.xebialabs.xlplatform.settings.shared

import akka.util.Timeout

import java.io.File
import scala.concurrent.duration.FiniteDuration

trait CommonSettings {
  def tasker: TaskerSettings
  def satellite: SatelliteSettings
  def server: ServerSettings
  def worker: WorkerSettings
  def scheduler: SchedulerSettings // get rid
  def inProcessTaskEngine: Boolean
  def algorithm:AlgorithmSettings
  def session: SessionSettings
}

trait TaskerSettings {
  def recoveryDir: File
  def maxActiveTasks: Int
  def shutdownTimeout: FiniteDuration
  def tickDuration: FiniteDuration
  def stepRetryDelay: FiniteDuration
  def enableCopyArtifactRetry: Boolean
  def askTimeout: Timeout
  def stepRunTimeout: FiniteDuration
  // 6 hours of default timeout / retry every 5 second
  def stepRetryCount: Int
  def asyncDnsEnabled: Boolean
}

trait SatelliteSettings {
  def uploadIdleTimeout: Timeout
  def pingTimeout: Timeout
  def remoteAskTimeout: Timeout
  def enabled: Boolean
  def streamingConnectionTimeout: Timeout
  def maxConcurrentUploads: Int
  def fileUploadAttempts: Int
}

trait ServerSettings {
  def hostname: String
  def aggregationTimeout: FiniteDuration
}

trait WorkerSettings {
  def connectInterval: FiniteDuration
  def reconnectDelay: FiniteDuration
  def reconnectInterval: FiniteDuration
}

trait AlgorithmSettings {
  def checksum: String
}

// get rid
trait SchedulerSettings {
  def tickDuration: FiniteDuration
}

trait SessionSettings {
  def cleanupCron: String
}

trait SerializationSettings {
  def serializationType: String
}
