package com.xebialabs.deployit.plugin.satellite

import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.deployit.plugin.satellite.Pinger.{FIVE_PINGS, defaultPingTimeout, isUp}
import com.xebialabs.xlplatform.satellite.Satellite
import org.apache.pekko.actor.ActorSystem

import scala.beans.BeanProperty

case class PingSatelliteStep(actorLocator: ActorLocator, @BeanProperty description: String,
                             satelliteAddress: SatelliteAddress, clock: Clock = Clock(), @transient system: ActorSystem) extends SatelliteActorSystemStep(system) {

  def getOrder: Int = Step.DEFAULT_ORDER

  def execute(ctx: ExecutionContext): StepExitCode = {
    val timeout = defaultPingTimeout(satelliteCommunicatorSystem)
    if (isUp(satelliteAddress, actorLocator, timeout, FIVE_PINGS, clock)(ctx, satelliteCommunicatorSystem))
      StepExitCode.SUCCESS
    else
      StepExitCode.FAIL
  }
}

object PingSatelliteStep {

  def apply(satellite: Satellite)(implicit satelliteCommunicatorSystem: ActorSystem): PingSatelliteStep = {
    new PingSatelliteStep(ActorLocator(satellite), s"Ping ${satellite.getName}", SatelliteAddress(satellite), system = satelliteCommunicatorSystem)
  }

}
