package com.xebialabs.deployit.plugin.satellite

import com.xebialabs.deployit.engine.tasker.StateChangeEventListenerActor.TaskStateEvent
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.engine.tasker.messages.RemoteTaskStateEvent
import grizzled.slf4j.Logging
import org.apache.pekko.actor.{Actor, ActorSelection, Props}

object TaskEventForwarder {
  def props(taskId: TaskId, remoteTaskActor: ActorSelection) = Props(classOf[TaskEventForwarder], taskId, remoteTaskActor)
}

class TaskEventForwarder(val taskId: TaskId, val remoteTaskActor: ActorSelection) extends Actor with Logging {
  override def receive: Receive = {
    case msg@TaskStateEvent(`taskId`, _, prevState, currState) =>
      debug(s"sending $msg to remote")
      remoteTaskActor ! RemoteTaskStateEvent(taskId, prevState, currState)
      if (currState.isFinal)
        context.stop(self)
  }
}
