package com.xebialabs.deployit.plugin.satellite

import com.xebialabs.deployit.plugin.satellite.UploadTaskSupervisor.Protocol.UploadFilesTask
import org.apache.pekko.actor._

class StreamingSupervisor extends Actor {
  def receive: Receive = {
    case task: UploadFilesTask =>
      val taskSupervisor = UploadTaskSupervisor.props(sender(), task)
      val satAddress = task.config.satelliteAddress
      context.actorOf(taskSupervisor,
        s"upload-supervisor-${task.config.taskId}-${satAddress.name}-${satAddress.hostname}:${satAddress.protocolPort}")
  }
}

object StreamingSupervisor {
  def props(): Props = Props[StreamingSupervisor]
}