package com.xebialabs.deployit.plugin.satellite

import com.xebialabs.deployit.checksum.DefaultChecksumAlgorithmProviderFactory
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator
import com.xebialabs.satellite.protocol.{GetInstalledExtensions, InstalledExtensions, Paths}
import com.xebialabs.xlplatform.io.FolderChecksum
import com.xebialabs.xlplatform.settings.CommonSettings
import org.apache.pekko.actor.ActorSystem
import org.apache.pekko.pattern._
import org.apache.pekko.util.Timeout

import java.io.File
import java.net.URI
import scala.concurrent.Await

object ExtensionsDelta {

  def calculateExtensionsDelta(extensionsLocator: ExtensionsLocator, actorLocator: ActorLocator, satelliteCommunicatorSystem: ActorSystem): InstalledExtensionsDelta = {
    val settings = CommonSettings(satelliteCommunicatorSystem)

    implicit val timeout: Timeout = settings.satellite.pingTimeout

    val satellitePluginManagement = actorLocator.locate(Paths.pluginManagement)(satelliteCommunicatorSystem)

    val satelliteInstalledExtensions = Await.result(
      (satellitePluginManagement ? GetInstalledExtensions).mapTo[InstalledExtensions], atMost = timeout.duration)

    InstalledExtensionsDelta(
      compareChecksum(satelliteInstalledExtensions.pluginsChecksum, extensionsLocator.plugins),
      compareChecksum(satelliteInstalledExtensions.pluginHotfixesChecksum, extensionsLocator.pluginHotfixes),
      compareChecksum(satelliteInstalledExtensions.satelliteHotfixesChecksum, extensionsLocator.satelliteHotfixes),
      compareChecksum(satelliteInstalledExtensions.extChecksum, extensionsLocator.ext))
  }

  private def compareChecksum(checksum: String, files: List[File]): Set[URI] = {
    if (checksum == FolderChecksum.calculateChecksum(files, DefaultChecksumAlgorithmProviderFactory.defaultComparisonAlgorithm)) {
      Set.empty
    } else {
      files.map(_.toURI).toSet
    }
  }
}
