package com.xebialabs.deployit.plugin.satellite

import java.io.{File, InputStream}

import com.xebialabs.deployit.io.{ArtifactFile, LocalFileBased}
import com.xebialabs.overthere.OverthereFile
import com.xebialabs.overthere.local.LocalFile

class PluginLocalFile(file: File) extends ArtifactFile with LocalFileBased {

  override def getRawStream: InputStream = getInputStream

  override protected def getLazyFile: OverthereFile = LocalFile.from(file)

  override def isResolvable: Boolean = true

  override def isResolved: Boolean = true

  override def getLocalFile: File = getLazyFile.asInstanceOf[LocalFile].getFile
}

object PluginLocalFile {
  def apply(file:File) = new PluginLocalFile(file)
}


