package com.xebialabs.deployit.plugin.satellite

import java.util.concurrent.ConcurrentHashMap

import com.xebialabs.xlplatform.satellite.Satellite

/**
  * This is a per-task singleton that keeps track of which satellites successfully received the task
  * and thus would need to be cleaned up in the cleanup phase.
  */
class TaskOnSatelliteCleanupCache extends Serializable {
  private[this] val satellitesToCleanup = new ConcurrentHashMap[Satellite, Boolean]()

  def registerForCleanup(satellite: Satellite): Unit = {
    satellitesToCleanup.put(satellite, true)
  }

  def isRegistered(satellite: Satellite): Boolean = {
    satellitesToCleanup.containsKey(satellite)
  }
}
