package com.xebialabs.satellite.serialization

import com.xebialabs.deployit.engine.tasker.TaskSpecification
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact
import com.xebialabs.xlplatform.satellite.SatelliteAware
import nl.javadude.scannit.Scannit
import org.apache.pekko.actor.ExtendedActorSystem

import scala.jdk.CollectionConverters._
import scala.util.Try

object TaskSpecificationSerialization {

  lazy val artifactTypes: List[Class[_ <: Artifact]] = Scannit.getInstance().getSubTypesOf(classOf[Artifact]).asScala.toList
  lazy val stepTypes: List[Class[_ <: SatelliteAware]] = Scannit.getInstance().getSubTypesOf(classOf[SatelliteAware]).asScala.toList

}

trait TaskSpecificationSerialization {

  def toBinary(obj: TaskSpecification): Try[(Array[Byte], FilesToUpload, Seq[Class[_ <: Artifact]], Seq[Class[_ <: Step]])]

  def fromBinary(bytes: Array[Byte],
                 files: UploadedFiles,
                 artifactImplems: Seq[Class[_ <: Artifact]],
                 stepImplems: Seq[Class[_ <: Step]]): Try[TaskSpecification]

}

trait TaskSpecificationSerializationProvider {
  def apply(extendedActorSystem: ExtendedActorSystem): TaskSpecificationSerialization
}
