package com.xebialabs.satellite.streaming

import com.xebialabs.satellite.streaming.DigesterStage._
import grizzled.slf4j.Logging
import org.apache.pekko.stream.scaladsl.{Source, StreamConverters}
import org.apache.pekko.util.ByteString

import java.io.InputStream
import scala.concurrent.Future

object UploadStage extends Logging {

  def source(startOn: Future[Any], inputStream: InputStream)(digesterOnComplete: ProcessDigest)(implicit streamConfig: StreamConfig): Source[ByteString, _] = {
    Source.future(startOn)
      .flatMapConcat(_ => StreamConverters.fromInputStream(() => inputStream, streamConfig.chunkSize))
      .via(DigesterStage.flow(digesterOnComplete)).via(Compression.compress)
  }
}
