package com.xebialabs.satellite.streaming

import org.apache.pekko.NotUsed
import org.apache.pekko.stream.scaladsl
import org.apache.pekko.stream.scaladsl.Flow
import org.apache.pekko.util.ByteString

object Compression {

  def decompress(implicit streamConfig: StreamConfig): Flow[ByteString, ByteString, NotUsed] = ifEnabled(scaladsl.Compression.gunzip())

  def compress(implicit streamConfig: StreamConfig): Flow[ByteString, ByteString, NotUsed] = ifEnabled(scaladsl.Compression.gzip)

  private[this] def ifEnabled(function: Flow[ByteString, ByteString, NotUsed])(implicit streamConfig: StreamConfig): Flow[ByteString, ByteString, NotUsed] = if (streamConfig.compression) {
    function
  } else {
    Flow.fromFunction(identity[ByteString])
  }
}
