package com.xebialabs.satellite.protocol

import java.net.InetSocketAddress
import java.util.UUID

import com.xebialabs.deployit.engine.tasker.TaskId

case class UploadFileForTask(id: UploadId, taskId: TaskId, fileName: String, path: String) {

  def filePath(workdir: String) = java.nio.file.Paths.get(workdir, taskId, path, fileName)
}

case class Connected(xldAddress: InetSocketAddress)

case class CannotConnect(reason: String)

case class FileUploaded(checksum: String, fileLength: Long)

object UploadReply {

  sealed trait UploadResult

  type Port = Int

  case class InitConnection(satellitePort: Port, chunkSize: Int, compression: Boolean, wantTls: Boolean = false)

  case object Ready

  case object Done extends UploadResult

  case class Error(cause: String) extends UploadResult

}

case class UploadId(id: UUID) extends AnyVal {

  override def toString = id.toString
}

object UploadId {
  def apply() = new UploadId(UUID.randomUUID())
}
