package com.xebialabs.satellite.serialization

import akka.actor.{ActorSystem, ClassicActorSystemProvider, ExtendedActorSystem, Extension, ExtensionId, ExtensionIdProvider}
import com.xebialabs.xlplatform.settings.CommonSettings

import scala.reflect.runtime.universe


class TaskSpecificationSerializationExtensionImpl(system: ExtendedActorSystem) extends Extension {

  private lazy val serializationProvider: String = {
    val config = system.settings.config
    val serializationType = new CommonSettings(config).serialization.serializationType
    config.getString(s"deploy.task.serialization.satellite.provider-mapping.$serializationType")
  }
  private lazy val provider: TaskSpecificationSerializationProvider = companion[TaskSpecificationSerializationProvider](serializationProvider)

  def createSerializer(): TaskSpecificationSerialization = provider(system)

  private def companion[T](name: String)(implicit man: Manifest[T]): T = {
    val runtimeMirror = universe.runtimeMirror(getClass.getClassLoader)
    val module = runtimeMirror.staticModule(name)
    val obj = runtimeMirror.reflectModule(module)
    obj.instance.asInstanceOf[T]
  }
}

object TaskSpecificationSerializationExtension extends ExtensionId[TaskSpecificationSerializationExtensionImpl] with ExtensionIdProvider {

  override def lookup = TaskSpecificationSerializationExtension

  override def createExtension(system: ExtendedActorSystem) = new TaskSpecificationSerializationExtensionImpl(system)

  override def get(system: ActorSystem): TaskSpecificationSerializationExtensionImpl = super.get(system)

  override def get(system: ClassicActorSystemProvider): TaskSpecificationSerializationExtensionImpl = super.get(system)
}
