package com.xebialabs.satellite.protocol

import com.xebialabs.deployit.engine.tasker.TaskId

object Directories {
  val PLUGINS = "plugins"
  val PLUGIN_HOTFIXES = "hotfix/plugins"
  val SATELLITE_HOTFIXES = "hotfix/satellite-lib"
  val EXT = "ext"
}

case object GetInstalledExtensions

case class InstalledExtensions(pluginsChecksum: String, pluginHotfixesChecksum: String, satelliteHotfixesChecksum: String, extChecksum: String)

case class ReplaceExtensionsFromTask(taskId: TaskId)

case object MaintenanceEvent

case object RestartSatellite
case object ForceRestartSatellite
case object GetSatelliteStatus

sealed trait SatelliteStatus
case object Restarting extends SatelliteStatus
case class WaitingRestart(runningTasks: Seq[TaskId]) extends SatelliteStatus
case class SatelliteRunning(since: Long) extends SatelliteStatus
