package com.xebialabs.satellite.serialization

import com.fasterxml.jackson.core.{JsonGenerator, JsonParser}
import com.fasterxml.jackson.databind.{DeserializationContext, JsonDeserializer, JsonSerializer, SerializerProvider}
import com.xebialabs.deployit.engine.tasker.StepBlock

package object yaml {

  class StepBlockSerializer extends JsonSerializer[StepBlock] {
    override def serialize(value: StepBlock, gen: JsonGenerator, serializers: SerializerProvider): Unit = {
      value.satellite match {
        case None =>
          gen.writeNull()
        case Some(_) =>
          gen.writeObject()
      }
    }
  }

  class StepBlockDeserializer extends JsonDeserializer[StepBlock] {
    override def deserialize(p: JsonParser, ctxt: DeserializationContext): StepBlock = {
      val value: StepBlock = p.readValueAs(classOf[StepBlock])
      Option(value) match {
        case None => null
        case Some(stepBlock) => stepBlock
      }
    }
  }
}
