package com.xebialabs.satellite.serialization.yaml

import ai.digital.deploy.task.serdes.yaml.YamlSerializable
import com.xebialabs.deployit.engine.tasker.TaskSpecification
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact
import com.xebialabs.satellite.serialization.TaskSpecificationSerialization.{artifactTypes, stepTypes}
import com.xebialabs.satellite.serialization.{FilesToUpload, TaskSpecificationSerialization, TaskSpecificationSerializationProvider, UploadedFiles}
import org.apache.pekko.actor.ExtendedActorSystem
import org.apache.pekko.serialization.SerializationExtension

import scala.util.Try

object YamlTaskSpecificationSerialization extends TaskSpecificationSerializationProvider {
  override def apply(extendedActorSystem: ExtendedActorSystem): TaskSpecificationSerialization =
    new YamlTaskSpecificationSerialization(extendedActorSystem)
}


private class YamlTaskSpecificationSerialization(val system: ExtendedActorSystem) extends TaskSpecificationSerialization {

  // TODO ENG-7355 add special serializer for satellite with ArtifactSerializer, StepSerializer, StepBlockSerializer
  lazy val yamlSerializer = SerializationExtension(system)
    .serializerFor(classOf[YamlSerializable])

  override def toBinary(obj: TaskSpecification): Try[(Array[Byte], FilesToUpload, Seq[Class[_ <: Artifact]], Seq[Class[_ <: Step]])] =
    Try {
      val files: FilesToUpload = Set()
      val output = yamlSerializer.toBinary(obj)
      (output, files, artifactTypes, stepTypes)
    }


  override def fromBinary(bytes: Array[Byte], files: UploadedFiles, artifactImplems: Seq[Class[_ <: Artifact]], stepImplems: Seq[Class[_ <: Step]]): Try[TaskSpecification] =
    Try {
      yamlSerializer.fromBinary(bytes, classOf[TaskSpecification]).asInstanceOf[TaskSpecification]
    }
}
