package com.xebialabs.satellite.serialization.yaml

import ai.digital.deploy.task.serdes.yaml.MixinForIgnoreType
import com.fasterxml.jackson.databind.Module.SetupContext
import com.fasterxml.jackson.databind.module.{SimpleDeserializers, SimpleModule, SimpleSerializers}
import com.xebialabs.deployit.engine.spi.execution.NonRemotableExecutionStateListener
import com.xebialabs.deployit.engine.tasker.StepBlock

class SatelliteModule extends SimpleModule {

  override def setupModule(context: SetupContext): Unit = {
    context.setMixInAnnotations(classOf[NonRemotableExecutionStateListener], classOf[MixinForIgnoreType])

    val serializers = new SimpleSerializers()
    serializers.addSerializer(classOf[StepBlock], new StepBlockSerializer)
    context.addSerializers(serializers)

    val deserializers = new SimpleDeserializers()
    deserializers.addDeserializer(classOf[StepBlock], new StepBlockDeserializer)
    context.addDeserializers(deserializers)
  }
}
