package com.xebialabs.satellite.serialization.kryo

import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.serializers.FieldSerializer
import com.xebialabs.deployit.engine.spi.execution.{ExecutionStateListener, NonRemotableExecutionStateListener}

class ExecutionStateListenerSerializer(kryo: Kryo) extends FieldSerializer[ExecutionStateListener](kryo, classOf[ExecutionStateListener]) {

  override def write(kryo: Kryo, output: Output, executionStateListener: ExecutionStateListener): Unit = {
    executionStateListener match {
      case _: NonRemotableExecutionStateListener =>
        output.writeByte(Kryo.NULL)

      case _ =>
        output.writeByte(Kryo.NOT_NULL)
        super.write(kryo, output, executionStateListener)
    }
  }

  override def read(kryo: Kryo, input: Input, `type`: Class[_ <: ExecutionStateListener]): ExecutionStateListener = {
    val readByte: Byte = input.readByte()
    readByte match {
      case Kryo.NULL =>
        null
      case Kryo.NOT_NULL =>
        super.read(kryo, input, `type`)
    }
  }
}
