package com.xebialabs.satellite.serialization.kryo

import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.serializers.FieldSerializer
import com.xebialabs.overthere.OverthereFile

import java.lang.reflect.Field

abstract class BaseCustomSerializer[T](kryo: Kryo, clazz: Class[_]) extends FieldSerializer[T](kryo, clazz) {

  def typeClass: Class[_]

  def fetchFileFields(clazz: Class[_]): Seq[Field] =
    fetchFields(clazz).filter(field => classOf[OverthereFile].isAssignableFrom(field.getType))

  def fetchFields(clazz: Class[_]): Seq[Field] = if (clazz != null) {
    clazz.getDeclaredFields.toIndexedSeq ++ fetchFields(clazz.getSuperclass)
  } else {
    Seq.empty
  }

  def isFieldExistsOnClass(fileField: Field): Boolean = {
    getFields.map(field => field.getField.getName).contains(fileField.getName)
  }
}
