package com.xebialabs.satellite.serialization.kryo

import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.serializers.FieldSerializer
import com.xebialabs.deployit.engine.tasker.StepBlock

class StepBlockSerializer(kryo: Kryo) extends FieldSerializer[StepBlock](kryo, classOf[StepBlock]) {

  override def write(kryo: Kryo, output: Output, stepBlock: StepBlock): Unit = {
    stepBlock.satellite match {
      case None =>
        output.writeByte(Kryo.NULL)

      case Some(_) =>
        output.writeByte(Kryo.NOT_NULL)
        super.write(kryo, output, stepBlock)
    }
  }

  override def read(kryo: Kryo, input: Input, `type`: Class[StepBlock]): StepBlock = {
    val readByte: Byte = input.readByte()
    readByte match {
      case Kryo.NULL => null
      case Kryo.NOT_NULL => super.read(kryo, input, `type`)
    }
  }

}
