/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.inspection.service.discovery;

import ai.digital.deploy.tasker.common.TaskType;
import com.google.common.base.Strings;
import com.xebialabs.deployit.engine.tasker.BlockBuilders$;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryContext;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryMessages;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryResult;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryResultsRetriever$;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryTrigger;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.task.TaskMetadataModifier;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I4Aa\u0003\u0007\u00013!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003#\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0004\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011U\u0002!\u0011!Q\u0001\nYBQ!\u000f\u0001\u0005\u0002iBq\u0001\u0011\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004B\u0001\u0001\u0006I!\r\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006A\u0002!\t!\u0019\u0002\u0011\t&\u001c8m\u001c<fef\u001cVM\u001d<jG\u0016T!!\u0004\b\u0002\u0013\u0011L7oY8wKJL(BA\b\u0011\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0005\n\u0002\u0015%t7\u000f]3di&|gN\u0003\u0002\u0014)\u0005AA-\u001a9m_fLGO\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002\rML8\u000f^3n+\u0005\u0011\u0003CA\u0012-\u001b\u0005!#BA\u0013'\u0003\u0015\t7\r^8s\u0015\t9\u0003&A\u0003qK.\\wN\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<\u0017BA\u0017%\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nA\u0005iqo\u001c:lKJl\u0015M\\1hKJ,\u0012!\r\t\u0003GIJ!a\r\u0013\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\fab^8sW\u0016\u0014X*\u00198bO\u0016\u0014\b%A\nj]B\u0013xnY3tgR\u000b7o[#oO&tW\r\u0005\u0002\u001co%\u0011\u0001\b\b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q!1(\u0010 @!\ta\u0004!D\u0001\r\u0011\u0015\u0001c\u00011\u0001#\u0011\u0015yc\u00011\u00012\u0011\u0015)d\u00011\u00017\u0003e!\u0017n]2pm\u0016\u0014\u0018PU3tk2$8OU3ue&,g/\u001a:\u00025\u0011L7oY8wKJL(+Z:vYR\u001c(+\u001a;sS\u00164XM\u001d\u0011\u0002!A\u0014X\r]1sK\u0012K7oY8wKJLHc\u0001#M1B\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0007i\u0006\u001c8.\u001a:\u000b\u0005%\u0013\u0012AB3oO&tW-\u0003\u0002L\r\n\tB+Y:l'B,7-\u001b4jG\u0006$\u0018n\u001c8\t\u000b5K\u0001\u0019\u0001(\u0002\u0005\rL\u0007CA(W\u001b\u0005\u0001&BA)S\u0003\r)H-\u001c\u0006\u0003'R\u000b1!\u00199j\u0015\t)&#\u0001\u0004qYV<\u0017N\\\u0005\u0003/B\u0013\u0011cQ8oM&<WO]1uS>t\u0017\n^3n\u0011\u0015I\u0016\u00021\u0001[\u0003\u001d9xN]6ESJ\u0004\"a\u00170\u000e\u0003qS!!\u0018\n\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002`9\n9qk\u001c:l\t&\u0014\u0018aE4fi\u0012K7oY8wKJL(+Z:vYR\u001cHC\u00012f!\ta4-\u0003\u0002e\u0019\tyA)[:d_Z,'/\u001f*fgVdG\u000fC\u0003g\u0015\u0001\u0007q-\u0001\u0004uCN\\\u0017\n\u001a\t\u0003Q>t!![7\u0011\u0005)dR\"A6\u000b\u00051D\u0012A\u0002\u001fs_>$h(\u0003\u0002o9\u00051\u0001K]3eK\u001aL!\u0001]9\u0003\rM#(/\u001b8h\u0015\tqG\u0004")
public class DiscoveryService {
    private final ActorSystem system;
    private final ActorRef workerManager;
    private final ActorRef discoveryResultsRetriever;

    public ActorSystem system() {
        return this.system;
    }

    public ActorRef workerManager() {
        return this.workerManager;
    }

    private ActorRef discoveryResultsRetriever() {
        return this.discoveryResultsRetriever;
    }

    public TaskSpecification prepareDiscovery(ConfigurationItem ci, WorkDir workDir) {
        DiscoveryContext inspectionContext = new DiscoveryContext();
        inspectionContext.discovered(ci);
        String description = "Inspection of " + ci.getId();
        PhaseContainer stepBlock = BlockBuilders$.MODULE$.steps(description, (Option)None$.MODULE$, (List)Nil$.MODULE$).build();
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, (TaskInspectionContext)inspectionContext, false);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        spec.getListeners().add(new DiscoveryTrigger(inspectionContext));
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"taskType", (String)TaskType.INSPECTION.name());
        return spec;
    }

    public DiscoveryResult getDiscoveryResults(String taskId) {
        Option<DiscoveryResult> option;
        Timeout timeout = Timeout$.MODULE$.apply(10L, TimeUnit.SECONDS);
        try {
            ActorRef qual$1 = package$.MODULE$.ask(this.discoveryResultsRetriever());
            DiscoveryMessages.RetrieveResults x$1 = new DiscoveryMessages.RetrieveResults(taskId);
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            option = ((DiscoveryMessages.DiscoveryResultsFound)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration())).discoveryResult();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Could not find any results associated with the id [%s]", (Object[])new Object[]{taskId}));
        }
        Option<DiscoveryResult> discoveryResult = option;
        return (DiscoveryResult)discoveryResult.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Could not find any results associated with the id [%s]", (Object[])new Object[]{taskId}));
        });
    }

    public DiscoveryService(ActorSystem system, ActorRef workerManager, boolean inProcessTaskEngine) {
        this.system = system;
        this.workerManager = workerManager;
        this.discoveryResultsRetriever = system.actorOf(DiscoveryResultsRetriever$.MODULE$.props(workerManager, inProcessTaskEngine), DiscoveryResultsRetriever$.MODULE$.name());
    }
}

